@echo off
setlocal EnableExtensions

if "%~1"=="" (
  echo Usage: CreateAES.bat "C:\path\to\DISDATA.PC1"
  exit /b 2
)

set "GPG_EXE=%ProgramFiles%\DirectPay\GnuPG\gpg.exe"
set "GNUPG_HOME=%ProgramData%\DirectPay\GnuPG"

if not exist "%GPG_EXE%" ( echo ERROR: gpg.exe not found at "%GPG_EXE%". & exit /b 1 )

set "INFILE=%~1"
if not exist "%INFILE%" ( echo ERROR: Input not found: "%INFILE%". & exit /b 1 )

set "OUTDIR=%~dp1"
set "BASENAME=%~n1"
set "OUTFILE=%OUTDIR%%BASENAME%.pc1.asc"

"%GPG_EXE%" --homedir "%GNUPG_HOME%" --yes --batch --trust-model always --armor ^
  --recipient mwalker@westpac.com.au ^
  --output "%OUTFILE%" --encrypt "%INFILE%"

if errorlevel 1 ( echo ERROR: Encryption failed. & exit /b 1 )

echo SUCCESS: "%OUTFILE%" created.
exit /b 0
